---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：101-GraphQL API

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **イントロスペクションクエリのキャッシュ期間**：設定ファイルによる変更可能性
  2. **Subscriptionの実装詳細**：WebSocket/ActionCable連携の詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/graphql_controller.rb`
- E-02: `app/graphql/gitlab_schema.rb`
- E-03: `app/graphql/types/query_type.rb`
- E-04: `app/graphql/types/mutation_type.rb`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クエリ複雑度上限は未認証200、認証250、管理者300 | E-02 (4-6行目) | ○ |
| C-02 | クエリ深度上限は未認証15、認証20 | E-02 (11-12行目) | ○ |
| C-03 | クエリサイズ制限は10,000文字 | E-01 (52行目 MAX_QUERY_SIZE) | ○ |
| C-04 | GETリクエストでMutationは禁止される | E-01 (74行目、171-176行目) | ○ |
| C-05 | マルチプレックスはApollo形式をサポート | E-01 (301-305行目) | ○ |
| C-06 | イントロスペクションクエリは1日キャッシュ | E-01 (350-352行目) | ○ |
| C-07 | 認証はセッションとアクセストークンの両方をサポート | E-01 (59行目) | ○ |
| C-08 | DPoP認証はオプションでサポート | E-01 (135-146行目) | ○ |
| C-09 | クエリタイムアウトはgitlab.ymlで設定 | E-02 (20行目) | ○ |
| C-10 | BatchLoaderでN+1防止 | E-02 (18行目) | ○ |
| C-11 | デフォルト最大ページサイズは100 | E-02 (31行目) | ○ |
| C-12 | VS Code利用追跡 | E-01 (223-225行目) | ○ |
| C-13 | JetBrains利用追跡 | E-01 (228-230行目) | ○ |
| C-14 | Neovim利用追跡 | E-01 (244-246行目) | ○ |
| C-15 | GitLab CLI利用追跡 | E-01 (248-250行目) | ○ |
| C-16 | 機能一覧でNo.101はGraphQL API | E-05 | ○ |
| C-17 | 画面No.319はGraphQL Explorer | E-06 | ○ |
| C-18 | エラーステータスマップが定義されている | E-01 (7-34行目) | ○ |
| C-19 | Queryタイプにprojectフィールド存在 | E-03 (156-160行目) | ○ |
| C-20 | Queryタイプにissueフィールド存在 | E-03 (95-99行目) | ○ |
| C-21 | ミューテーションにIssues::Create存在 | E-04 (84行目) | ○ |
| C-22 | ミューテーションにMergeRequests::Create存在 | E-04 (102行目) | ○ |
| C-23 | 認証なしでも公開データにアクセス可能 | E-01 (37行目 skip_before_action) | ○ |
| C-24 | Subscriptionの実装詳細 | **根拠不足** | △ |
| C-25 | リゾルバの実装パターン詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Subscriptionの実装詳細（ActionCableとの連携）
  - 候補：`app/graphql/types/subscription_type.rb` / `app/channels/` / GraphQL-Rubyドキュメント
- リゾルバの実装パターン詳細
  - 候補：`app/graphql/resolvers/` 配下の具体的なリゾルバ実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な機能記述は全てコードから確認済み
- 1: 中リスク - Subscription機能の詳細実装は追加調査が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] クエリ複雑度上限の値が本番設定と一致するか確認
- [ ] タイムアウト値がgitlab.ymlの設定と一致するか確認
- [ ] Subscription機能の利用状況を確認
- [ ] 最新のMutation追加状況を確認
